"use strict";
exports.__esModule = true;
exports.isDateOnDayOfMonth = void 0;
var is_date_1 = require("./is-date");
var is_number_1 = require("./is-number");
var curry2_1 = require("./lib/curry2");
/**
 * Asserts that a value is an instance of `Date` occurring on the given day of
 * the month, where the first day of the month is `1` and last is `31`.
 * @param dayOfMonth 29
 * @param value new Date('2021-08-29')
 * @matcherName toBeDateOnDayOfMonth
 * @memberMatcherName toHaveDateOnDayOfMonth
 * @matcherMessage expected ${value} to be an instance of Date occurring on the
 * ${dayOfMonth} day of the month
 * @matcherNotMessage expected ${value} not to be an instance of Date occurring
 * on the ${dayOfMonth} day of the month
 */
exports.isDateOnDayOfMonth = (0, curry2_1.curry2)(function (dayOfMonth, value) {
    return (0, is_date_1.isDate)(value) && (0, is_number_1.isNumber)(dayOfMonth) && value.getDate() === dayOfMonth;
});
