"use strict";
exports.__esModule = true;
exports.isDateBetween = void 0;
var is_date_1 = require("./is-date");
var is_greater_than_or_equal_to_1 = require("./is-greater-than-or-equal-to");
var is_less_than_or_equal_to_1 = require("./is-less-than-or-equal-to");
var curry3_1 = require("./lib/curry3");
/**
 * Asserts that a value is an instance of `Date` occurring on or after `floor`
 * and on or before `ceiling`.
 * @param floor new Date('2019-12-10')
 * @param ceiling new Date('2019-12-12')
 * @param value new Date('2019-12-11')
 * @matcherName toBeDateBetween
 * @memberMatcherName toHaveDateBetween
 * @matcherMessage expected ${value} to be an instance of Date occurring on or
 * after ${floor} and on or before ${ceiling}
 * @matcherNotMessage expected ${value} not to be an instance of Date occurring
 * on or after ${floor} and on or before ${ceiling}
 */
exports.isDateBetween = (0, curry3_1.curry3)(function (floor, ceiling, value) {
    return (0, is_date_1.isDate)(value) &&
        (0, is_date_1.isDate)(floor) &&
        (0, is_date_1.isDate)(ceiling) &&
        (0, is_less_than_or_equal_to_1.isLessThanOrEqualTo)(ceiling.getTime(), value.getTime()) &&
        (0, is_greater_than_or_equal_to_1.isGreaterThanOrEqualTo)(floor.getTime(), value.getTime());
});
