"use strict";
exports.__esModule = true;
exports.isBefore = void 0;
var is_after_1 = require("./is-after");
var curry2_1 = require("./lib/curry2");
/**
 * Asserts that a value is a valid instance of `Date` whose value occurs before
 * that of another.
 * @param other new Date('2020-01-01')
 * @param value new Date('2019-12-31')
 * @matcherName toBeBefore
 * @memberMatcherName toHaveDateBefore
 * @matcherMessage expected ${value} to be an instance of Date, occurring before
 * ${other}
 * @matcherNotMessage expected ${value} not to be an instance of Date, occurring
 * before ${other}
 */
exports.isBefore = (0, curry2_1.curry2)(function (other, value) {
    return (0, is_after_1.isAfter)(value, other);
});
