/**
 * Asserts that a value is a function using `async` and `await` syntax.
 * @param value async () => { await fetch('...') }
 * @matcherName toBeAsyncFunction
 * @memberMatcherName toHaveAsyncFunction
 * @matcherMessage expected ${value} to be a `Function` using async/await syntax
 * @matcherNotMessage expected ${value} not to be a function using async/await
 * syntax
 */
export declare const isAsyncFunction: <CallTimeType = (...args: any[]) => Promise<any>>(value: unknown) => value is CallTimeType;
