/**
 * Asserts that a value is an `Array` containing only `Object` values.
 * @param value [{}, new Object()]
 * @matcherName toBeArrayOfObjects
 * @memberMatcherName toHaveArrayOfObjects
 * @matcherMessage expected ${value} to be a non-empty array, containing only
 * objects
 * @matcherNotMessage expected ${value} not to be a non-empty array, containing
 * only objects
 */
export declare const isArrayOfObjects: <T extends any[] = any[]>(value: unknown) => value is T;
