/**
 * Asserts that a value is an `Array` including only the values provided in the
 * given `allowedValues` array and no others. The order and number of times each
 * value appears in either array does not matter. Returns true unless `value`
 * contains a value which does not feature in `allowedValues`.
 * @param allowedValues [1, 5, 10]
 * @param value [5, 10, 1]
 * @matcherName toBeArrayIncludingOnly
 * @memberMatcherName toHaveArrayIncludingOnly
 * @matcherMessage expected ${value} to only include values featured in
 * ${allowedValues} and no others
 * @matcherNotMessage expected ${value} not to only include values featured in
 * ${allowedValues} and no others
 */
export declare const isArrayIncludingOnly: import("./lib/curry2").CurriedFn2<any[]>;
