"use strict";
exports.__esModule = true;
exports.isArrayIncludingAnyOf = void 0;
var is_array_1 = require("./is-array");
var curry2_1 = require("./lib/curry2");
var is_jest_equal_1 = require("./lib/is-jest-equal");
var some_1 = require("./lib/some");
/**
 * Asserts that `value` is an `Array` including at least one of the members of
 * `allowedValues`.
 * @param allowedValues ['Ginola', 3]
 * @param value [12, 0, 14, 'Ginola']
 * @matcherName toBeArrayIncludingAnyOf
 * @memberMatcherName toHaveArrayIncludingAnyOf
 * @matcherMessage expected ${value} to include at least one of the values in
 * ${allowedValues}
 * @matcherNotMessage expected ${value} not to include at least one of the
 * values in ${allowedValues}
 */
exports.isArrayIncludingAnyOf = (0, curry2_1.curry2)(function (allowedValues, value) {
    return (0, is_array_1.isArray)(allowedValues) &&
        (0, is_array_1.isArray)(value) &&
        (0, some_1.some)(function (allowedValue) { return (0, some_1.some)((0, is_jest_equal_1.isJestEqual)(allowedValue), value); }, allowedValues);
});
