/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that value is a string whose trailing characters are equal to those of the provided string.
             * @example
             * expect('JavaScript').toStartWith('Java');
             */
            toStartWith(otherString: string): R;
        }
        interface Expect {
            /**
             * Asserts that value is a string whose trailing characters are equal to those of the provided string.
             * @example
             * expect('JavaScript').toEqual(
             *   expect.toStartWith('Java')
             * );
             */
            toStartWith<T>(otherString: string): JestMatchers<T>;
        }
    }
}
export declare const toStartWithMatcher: (value: unknown, otherString: string) => jest.CustomMatcherResult;
