/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a `Number` which is both greater than or equal to `floor` and less than or equal to `ceiling`.
             * @example
             * expect(7).toBeWithinRange(0, 10);
             */
            toBeWithinRange(floor: number, ceiling: number): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a `Number` which is both greater than or equal to `floor` and less than or equal to `ceiling`.
             * @example
             * expect(7).toEqual(
             *   expect.toBeWithinRange(0, 10)
             * );
             */
            toBeWithinRange<T>(floor: number, ceiling: number): JestMatchers<T>;
        }
    }
}
export declare const toBeWithinRangeMatcher: (value: unknown, floor: number, ceiling: number) => jest.CustomMatcherResult;
