/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a `Number` with no positive decimal places.
             * @example
             * expect(8).toBeWholeNumber();
             */
            toBeWholeNumber(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a `Number` with no positive decimal places.
             * @example
             * expect(8).toEqual(
             *   expect.toBeWholeNumber()
             * );
             */
            toBeWholeNumber<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeWholeNumberMatcher: (value: unknown) => jest.CustomMatcherResult;
