/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a `String` containing only whitespace characters.
             * @example
             * expect(' ').toBeWhitespace();
             */
            toBeWhitespace(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a `String` containing only whitespace characters.
             * @example
             * expect(' ').toEqual(
             *   expect.toBeWhitespace()
             * );
             */
            toBeWhitespace<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeWhitespaceMatcher: (value: unknown) => jest.CustomMatcherResult;
