/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a `String` or `new String()`.
             * @example
             * expect('i am a string').toBeString();
             */
            toBeString(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a `String` or `new String()`.
             * @example
             * expect('i am a string').toEqual(
             *   expect.toBeString()
             * );
             */
            toBeString<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeStringMatcher: (value: unknown) => jest.CustomMatcherResult;
