/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a `String` or `Array` whose length is less than that of the other provided.
             * @example
             * expect(['i have one item']).toBeShorterThan(['i', 'have', 4, 'items']);
             */
            toBeShorterThan(other: string | any[]): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a `String` or `Array` whose length is less than that of the other provided.
             * @example
             * expect(['i have one item']).toEqual(
             *   expect.toBeShorterThan(['i', 'have', 4, 'items'])
             * );
             */
            toBeShorterThan<T>(other: string | any[]): JestMatchers<T>;
        }
    }
}
export declare const toBeShorterThanMatcher: (value: unknown, other: string | any[]) => jest.CustomMatcherResult;
