"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeSameLengthAsMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeSameLengthAsMatcher = function (value, other) {
    return (0, create_result_1.createResult)({
        message: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to be a string or array whose length is the same as that of ").concat((0, jest_matcher_utils_1.printExpected)(other));
        },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to be a string or array whose length is the same as that of ").concat((0, jest_matcher_utils_1.printExpected)(other));
        },
        pass: (0, expect_more_1.isSameLengthAs)(other, value)
    });
};
exports.toBeSameLengthAsMatcher = toBeSameLengthAsMatcher;
expect.extend({ toBeSameLengthAs: exports.toBeSameLengthAsMatcher });
