/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a `String` or `Array` whose length is the same as that of the other provided.
             * @example
             * expect(['i also have', '2 items']).toBeSameLengthAs(['i have', '2 items']);
             */
            toBeSameLengthAs(other: string | any[]): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a `String` or `Array` whose length is the same as that of the other provided.
             * @example
             * expect(['i also have', '2 items']).toEqual(
             *   expect.toBeSameLengthAs(['i have', '2 items'])
             * );
             */
            toBeSameLengthAs<T>(other: string | any[]): JestMatchers<T>;
        }
    }
}
export declare const toBeSameLengthAsMatcher: (value: unknown, other: string | any[]) => jest.CustomMatcherResult;
