/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a `Number` greater than 0.
             * @example
             * expect(5).toBePositiveNumber();
             */
            toBePositiveNumber(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a `Number` greater than 0.
             * @example
             * expect(5).toEqual(
             *   expect.toBePositiveNumber()
             * );
             */
            toBePositiveNumber<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBePositiveNumberMatcher: (value: unknown) => jest.CustomMatcherResult;
