/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is equal to ${other} or undefined.
             * @example
             * expect({ x: 12, y: 22 }).toBeOptionalOf({
             *   x: expect.toBeNumber(),
             *   y: expect.toBeNumber(),
             * });
             * expect(undefined).toBeOptionalOf({
             *   x: expect.toBeNumber(),
             *   y: expect.toBeNumber(),
             * });
             */
            toBeOptionalOf(other: unknown): R;
        }
        interface Expect {
            /**
             * Asserts that a value is equal to ${other} or undefined.
             * @example
             * expect({ x: 12, y: 22 }).toEqual(
             *   expect.toBeOptionalOf({
             *     x: expect.toBeNumber(),
             *     y: expect.toBeNumber()
             *   })
             * );
             * expect(undefined).toEqual(
             *   expect.toBeOptionalOf({
             *     x: expect.toBeNumber(),
             *     y: expect.toBeNumber()
             *   })
             * );
             */
            toBeOptionalOf<T>(other: unknown): JestMatchers<T>;
        }
    }
}
export declare const toBeOptionalOfMatcher: (value: unknown, other: unknown) => jest.CustomMatcherResult;
