/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an `Object`.
             * @example
             * expect({}).toBeObject();
             */
            toBeObject(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an `Object`.
             * @example
             * expect({}).toEqual(
             *   expect.toBeObject()
             * );
             */
            toBeObject<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeObjectMatcher: (value: unknown) => jest.CustomMatcherResult;
