"use strict";
exports.__esModule = true;
exports.toBeNullableOfMatcher = void 0;
var expect_utils_1 = require("@jest/expect-utils");
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeNullableOfMatcher = function (value, other) {
    return (0, create_result_1.createResult)({
        message: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to equal ").concat((0, jest_matcher_utils_1.printExpected)(other), " or ").concat((0, jest_matcher_utils_1.printExpected)(null));
        },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to equal ").concat((0, jest_matcher_utils_1.printExpected)(other), " or ").concat((0, jest_matcher_utils_1.printExpected)(null));
        },
        pass: (0, expect_more_1.isNull)(value) || (0, expect_utils_1.equals)(value, other)
    });
};
exports.toBeNullableOfMatcher = toBeNullableOfMatcher;
expect.extend({ toBeNullableOf: exports.toBeNullableOfMatcher });
