"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeNonEmptyStringMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeNonEmptyStringMatcher = function (value) {
    return (0, create_result_1.createResult)({
        message: function () { return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to be a string with at least one character"); },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to be a string with at least one character");
        },
        pass: (0, expect_more_1.isNonEmptyString)(value)
    });
};
exports.toBeNonEmptyStringMatcher = toBeNonEmptyStringMatcher;
expect.extend({ toBeNonEmptyString: exports.toBeNonEmptyStringMatcher });
