/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a valid `String` containing at least one character.
             * @example
             * expect('i am not empty').toBeNonEmptyString();
             */
            toBeNonEmptyString(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a valid `String` containing at least one character.
             * @example
             * expect('i am not empty').toEqual(
             *   expect.toBeNonEmptyString()
             * );
             */
            toBeNonEmptyString<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeNonEmptyStringMatcher: (value: unknown) => jest.CustomMatcherResult;
