/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an `Array` containing at least one value.
             * @example
             * expect(['i', 'am not empty']).toBeNonEmptyArray();
             */
            toBeNonEmptyArray(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an `Array` containing at least one value.
             * @example
             * expect(['i', 'am not empty']).toEqual(
             *   expect.toBeNonEmptyArray()
             * );
             */
            toBeNonEmptyArray<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeNonEmptyArrayMatcher: (value: unknown) => jest.CustomMatcherResult;
