/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is `null` or `undefined`
             * @example
             * expect(undefined).toBeNil();
             */
            toBeNil(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is `null` or `undefined`
             * @example
             * expect(undefined).toEqual(
             *   expect.toBeNil()
             * );
             */
            toBeNil<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeNilMatcher: (value: unknown) => jest.CustomMatcherResult;
