/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a `Number` less than 0.
             * @example
             * expect(-18).toBeNegativeNumber();
             */
            toBeNegativeNumber(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a `Number` less than 0.
             * @example
             * expect(-18).toEqual(
             *   expect.toBeNegativeNumber()
             * );
             */
            toBeNegativeNumber<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeNegativeNumberMatcher: (value: unknown) => jest.CustomMatcherResult;
