/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a `String` or `Array` whose length is greater than that of another.
             * @example
             * expect(['i', 'have', 3]).toBeLongerThan([2, 'items']);
             */
            toBeLongerThan(other: string | any[]): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a `String` or `Array` whose length is greater than that of another.
             * @example
             * expect(['i', 'have', 3]).toEqual(
             *   expect.toBeLongerThan([2, 'items'])
             * );
             */
            toBeLongerThan<T>(other: string | any[]): JestMatchers<T>;
        }
    }
}
export declare const toBeLongerThanMatcher: (value: unknown, other: string | any[]) => jest.CustomMatcherResult;
