/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a `String` of valid JSON.
             * @example
             * expect('{"i":"am valid JSON"}').toBeJsonString();
             */
            toBeJsonString(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a `String` of valid JSON.
             * @example
             * expect('{"i":"am valid JSON"}').toEqual(
             *   expect.toBeJsonString()
             * );
             */
            toBeJsonString<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeJsonStringMatcher: (value: unknown) => jest.CustomMatcherResult;
