/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a String which conforms to common use-cases of the ISO 8601 standard representation of dates and times.
             * @example
             * expect('1999-12-31T23:59:59').toBeIso8601();
             */
            toBeIso8601(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a String which conforms to common use-cases of the ISO 8601 standard representation of dates and times.
             * @example
             * expect('1999-12-31T23:59:59').toEqual(
             *   expect.toBeIso8601()
             * );
             */
            toBeIso8601<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeIso8601Matcher: (value: unknown) => jest.CustomMatcherResult;
