/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a `Function` using `yield` syntax.
             * @example
             * expect(function* gen() { yield 'i am a generator' }).toBeGeneratorFunction();
             */
            toBeGeneratorFunction(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a `Function` using `yield` syntax.
             * @example
             * expect(function* gen() { yield 'i am a generator' }).toEqual(
             *   expect.toBeGeneratorFunction()
             * );
             */
            toBeGeneratorFunction<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeGeneratorFunctionMatcher: (value: unknown) => jest.CustomMatcherResult;
