/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a valid `Object` containing no instance members.
             * @example
             * expect({}).toBeEmptyObject();
             */
            toBeEmptyObject(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a valid `Object` containing no instance members.
             * @example
             * expect({}).toEqual(
             *   expect.toBeEmptyObject()
             * );
             */
            toBeEmptyObject<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeEmptyObjectMatcher: (value: unknown) => jest.CustomMatcherResult;
