/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a valid `Array` containing no items.
             * @example
             * expect([]).toBeEmptyArray();
             */
            toBeEmptyArray(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a valid `Array` containing no items.
             * @example
             * expect([]).toEqual(
             *   expect.toBeEmptyArray()
             * );
             */
            toBeEmptyArray<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeEmptyArrayMatcher: (value: unknown) => jest.CustomMatcherResult;
