"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeDateOnOrBeforeMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeDateOnOrBeforeMatcher = function (value, other) {
    return (0, create_result_1.createResult)({
        message: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to be an instance of Date occurring on or before ").concat((0, jest_matcher_utils_1.printExpected)(other));
        },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to be an instance of Date occurring on or before ").concat((0, jest_matcher_utils_1.printExpected)(other));
        },
        pass: (0, expect_more_1.isDateOnOrBefore)(other, value)
    });
};
exports.toBeDateOnOrBeforeMatcher = toBeDateOnOrBeforeMatcher;
expect.extend({ toBeDateOnOrBefore: exports.toBeDateOnOrBeforeMatcher });
