"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeDateOnOrAfterMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeDateOnOrAfterMatcher = function (value, other) {
    return (0, create_result_1.createResult)({
        message: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to be an instance of Date occurring on or after ").concat((0, jest_matcher_utils_1.printExpected)(other));
        },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to be an instance of Date occurring on or after ").concat((0, jest_matcher_utils_1.printExpected)(other));
        },
        pass: (0, expect_more_1.isDateOnOrAfter)(other, value)
    });
};
exports.toBeDateOnOrAfterMatcher = toBeDateOnOrAfterMatcher;
expect.extend({ toBeDateOnOrAfter: exports.toBeDateOnOrAfterMatcher });
