"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeDateOnDayOfWeekMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeDateOnDayOfWeekMatcher = function (value, index) {
    return (0, create_result_1.createResult)({
        message: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to be an instance of Date occurring on the day of the week with index ").concat((0, jest_matcher_utils_1.printExpected)(index));
        },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to be an instance of Date occurring on the day of the week with index ").concat((0, jest_matcher_utils_1.printExpected)(index));
        },
        pass: (0, expect_more_1.isDateOnDayOfWeek)(index, value)
    });
};
exports.toBeDateOnDayOfWeekMatcher = toBeDateOnDayOfWeekMatcher;
expect.extend({ toBeDateOnDayOfWeek: exports.toBeDateOnDayOfWeekMatcher });
