/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an instance of `Date` occurring on the day of the week with the given index, where Sunday is `0` and Saturday is `6`.
             * @example
             * expect(new Date('2021-08-29')).toBeDateOnDayOfWeek(0);
             */
            toBeDateOnDayOfWeek(index: number): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an instance of `Date` occurring on the day of the week with the given index, where Sunday is `0` and Saturday is `6`.
             * @example
             * expect(new Date('2021-08-29')).toEqual(
             *   expect.toBeDateOnDayOfWeek(0)
             * );
             */
            toBeDateOnDayOfWeek<T>(index: number): JestMatchers<T>;
        }
    }
}
export declare const toBeDateOnDayOfWeekMatcher: (value: unknown, index: number) => jest.CustomMatcherResult;
