"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeDateOnDayOfMonthMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeDateOnDayOfMonthMatcher = function (value, dayOfMonth) {
    return (0, create_result_1.createResult)({
        message: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to be an instance of Date occurring on the ").concat((0, jest_matcher_utils_1.printExpected)(dayOfMonth), " day of the month");
        },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to be an instance of Date occurring on the ").concat((0, jest_matcher_utils_1.printExpected)(dayOfMonth), " day of the month");
        },
        pass: (0, expect_more_1.isDateOnDayOfMonth)(dayOfMonth, value)
    });
};
exports.toBeDateOnDayOfMonthMatcher = toBeDateOnDayOfMonthMatcher;
expect.extend({ toBeDateOnDayOfMonth: exports.toBeDateOnDayOfMonthMatcher });
