"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeDateInYearMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeDateInYearMatcher = function (value, year) {
    return (0, create_result_1.createResult)({
        message: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to be an instance of Date occurring in the year ").concat((0, jest_matcher_utils_1.printExpected)(year));
        },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to be an instance of Date occurring in the year ").concat((0, jest_matcher_utils_1.printExpected)(year));
        },
        pass: (0, expect_more_1.isDateInYear)(year, value)
    });
};
exports.toBeDateInYearMatcher = toBeDateInYearMatcher;
expect.extend({ toBeDateInYear: exports.toBeDateInYearMatcher });
