/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an instance of `Date` occurring in the given year.
             * @example
             * expect(new Date('2021-08-29')).toBeDateInYear(2021);
             */
            toBeDateInYear(year: number): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an instance of `Date` occurring in the given year.
             * @example
             * expect(new Date('2021-08-29')).toEqual(
             *   expect.toBeDateInYear(2021)
             * );
             */
            toBeDateInYear<T>(year: number): JestMatchers<T>;
        }
    }
}
export declare const toBeDateInYearMatcher: (value: unknown, year: number) => jest.CustomMatcherResult;
