/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an instance of `Date` occurring on the given month of the year, where January is `0` and December is `11`.
             * @example
             * expect(new Date('2021-08-29')).toBeDateInMonth(7);
             */
            toBeDateInMonth(index: number): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an instance of `Date` occurring on the given month of the year, where January is `0` and December is `11`.
             * @example
             * expect(new Date('2021-08-29')).toEqual(
             *   expect.toBeDateInMonth(7)
             * );
             */
            toBeDateInMonth<T>(index: number): JestMatchers<T>;
        }
    }
}
export declare const toBeDateInMonthMatcher: (value: unknown, index: number) => jest.CustomMatcherResult;
