/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Assert value can be used in Mathemetic calculations despite not being a `Number`, for example `'1' * '2' === 2` whereas `'wut?' * 2 === NaN`.
             * @example
             * expect('100').toBeCalculable();
             */
            toBeCalculable(): R;
        }
        interface Expect {
            /**
             * Assert value can be used in Mathemetic calculations despite not being a `Number`, for example `'1' * '2' === 2` whereas `'wut?' * 2 === NaN`.
             * @example
             * expect('100').toEqual(
             *   expect.toBeCalculable()
             * );
             */
            toBeCalculable<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeCalculableMatcher: (value: unknown) => jest.CustomMatcherResult;
