/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a function using `async` and `await` syntax.
             * @example
             * expect(async () => { await fetch('...') }).toBeAsyncFunction();
             */
            toBeAsyncFunction(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a function using `async` and `await` syntax.
             * @example
             * expect(async () => { await fetch('...') }).toEqual(
             *   expect.toBeAsyncFunction()
             * );
             */
            toBeAsyncFunction<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeAsyncFunctionMatcher: (value: unknown) => jest.CustomMatcherResult;
