/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an `Array` containing only `String` values.
             * @example
             * expect(['we', 'are', 'all', 'strings']).toBeArrayOfStrings();
             */
            toBeArrayOfStrings(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an `Array` containing only `String` values.
             * @example
             * expect(['we', 'are', 'all', 'strings']).toEqual(
             *   expect.toBeArrayOfStrings()
             * );
             */
            toBeArrayOfStrings<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeArrayOfStringsMatcher: (value: unknown) => jest.CustomMatcherResult;
