/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an `Array` containing a specific number of values.
             * @example
             * expect(['i', 'contain', 4, 'items']).toBeArrayOfSize(4);
             */
            toBeArrayOfSize(size: number): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an `Array` containing a specific number of values.
             * @example
             * expect(['i', 'contain', 4, 'items']).toEqual(
             *   expect.toBeArrayOfSize(4)
             * );
             */
            toBeArrayOfSize<T>(size: number): JestMatchers<T>;
        }
    }
}
export declare const toBeArrayOfSizeMatcher: (value: unknown, size: number) => jest.CustomMatcherResult;
