/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an `Array` containing only `Number` values.
             * @example
             * expect([12, 0, 14]).toBeArrayOfNumbers();
             */
            toBeArrayOfNumbers(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an `Array` containing only `Number` values.
             * @example
             * expect([12, 0, 14]).toEqual(
             *   expect.toBeArrayOfNumbers()
             * );
             */
            toBeArrayOfNumbers<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeArrayOfNumbersMatcher: (value: unknown) => jest.CustomMatcherResult;
