"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeArrayOfBooleansMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeArrayOfBooleansMatcher = function (value) {
    return (0, create_result_1.createResult)({
        message: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to be a non-empty array, containing only boolean values");
        },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to be a non-empty array, containing only boolean values");
        },
        pass: (0, expect_more_1.isArrayOfBooleans)(value)
    });
};
exports.toBeArrayOfBooleansMatcher = toBeArrayOfBooleansMatcher;
expect.extend({ toBeArrayOfBooleans: exports.toBeArrayOfBooleansMatcher });
