/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an `Array` containing only `Boolean` values.
             * @example
             * expect([true, false, new Boolean(true)]).toBeArrayOfBooleans();
             */
            toBeArrayOfBooleans(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an `Array` containing only `Boolean` values.
             * @example
             * expect([true, false, new Boolean(true)]).toEqual(
             *   expect.toBeArrayOfBooleans()
             * );
             */
            toBeArrayOfBooleans<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeArrayOfBooleansMatcher: (value: unknown) => jest.CustomMatcherResult;
