"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeArrayIncludingOnlyMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeArrayIncludingOnlyMatcher = function (value, allowedValues) {
    return (0, create_result_1.createResult)({
        message: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to only include values featured in ").concat((0, jest_matcher_utils_1.printExpected)(allowedValues), " and no others");
        },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to only include values featured in ").concat((0, jest_matcher_utils_1.printExpected)(allowedValues), " and no others");
        },
        pass: (0, expect_more_1.isArrayIncludingOnly)(allowedValues, value)
    });
};
exports.toBeArrayIncludingOnlyMatcher = toBeArrayIncludingOnlyMatcher;
expect.extend({ toBeArrayIncludingOnly: exports.toBeArrayIncludingOnlyMatcher });
