"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeArrayIncludingAnyOfMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeArrayIncludingAnyOfMatcher = function (value, allowedValues) {
    return (0, create_result_1.createResult)({
        message: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to include at least one of the values in ").concat((0, jest_matcher_utils_1.printExpected)(allowedValues));
        },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to include at least one of the values in ").concat((0, jest_matcher_utils_1.printExpected)(allowedValues));
        },
        pass: (0, expect_more_1.isArrayIncludingAnyOf)(allowedValues, value)
    });
};
exports.toBeArrayIncludingAnyOfMatcher = toBeArrayIncludingAnyOfMatcher;
expect.extend({ toBeArrayIncludingAnyOf: exports.toBeArrayIncludingAnyOfMatcher });
