"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeArrayIncludingAllOfMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeArrayIncludingAllOfMatcher = function (value, requiredValues) {
    return (0, create_result_1.createResult)({
        message: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to include every value provided in ").concat((0, jest_matcher_utils_1.printExpected)(requiredValues));
        },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to include every value provided in ").concat((0, jest_matcher_utils_1.printExpected)(requiredValues));
        },
        pass: (0, expect_more_1.isArrayIncludingAllOf)(requiredValues, value)
    });
};
exports.toBeArrayIncludingAllOfMatcher = toBeArrayIncludingAllOfMatcher;
expect.extend({ toBeArrayIncludingAllOf: exports.toBeArrayIncludingAllOfMatcher });
