/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that `value` is an `Array` including all of the values provided in `requiredValues`. It could also include additional values or be in a different order, but if every value in `requiredValues` features in `value` then this will return `true`.
             * @example
             * expect([12, 0, 14, 'Ivo']).toBeArrayIncludingAllOf(['Ivo', 14]);
             */
            toBeArrayIncludingAllOf(requiredValues: unknown[]): R;
        }
        interface Expect {
            /**
             * Asserts that `value` is an `Array` including all of the values provided in `requiredValues`. It could also include additional values or be in a different order, but if every value in `requiredValues` features in `value` then this will return `true`.
             * @example
             * expect([12, 0, 14, 'Ivo']).toEqual(
             *   expect.toBeArrayIncludingAllOf(['Ivo', 14])
             * );
             */
            toBeArrayIncludingAllOf<T>(requiredValues: unknown[]): JestMatchers<T>;
        }
    }
}
export declare const toBeArrayIncludingAllOfMatcher: (value: unknown, requiredValues: unknown[]) => jest.CustomMatcherResult;
