"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
const promises_1 = require("node:fs/promises");
const eslint_formatter_stylish_1 = __importDefault(require("eslint-formatter-stylish"));
const eslint_formatter_json_1 = __importDefault(require("eslint-formatter-json"));
const command_1 = require("./command");
const utils_1 = require("./utils");
const severities = {
    0: 'debug',
    1: 'warning',
    2: 'error',
};
const format = async (results, data) => {
    if (process.env['GITHUB_ACTIONS'] !== 'true') {
        // @ts-expect-error typings are broken, `stylish` does expect `results`.
        return (0, eslint_formatter_stylish_1.default)(results, data);
    }
    if (process.env['SONARSCANNER'] === 'true') {
        // @ts-expect-error typings are broken, `json` does expect `results`.
        const result = (0, eslint_formatter_json_1.default)(results, data);
        if (process.env['GITHUB_WORKSPACE']) {
            await (0, promises_1.writeFile)(`${process.env['GITHUB_WORKSPACE']}/eslint-report.json`, result, { encoding: 'utf-8' });
            return '';
        }
        return result;
    }
    const commands = [
        (0, command_1.issueCommand)('group', {}, 'ESLint Annotations'),
        ...results.flatMap(({ filePath: file, messages }) => messages.map(({ message, severity, line, column: col, ruleId }) => (0, command_1.issueCommand)(severities[severity], { file, line, col }, (0, utils_1.formatMessage)(message, ruleId)))),
        (0, command_1.issueCommand)('endgroup'),
    ];
    return commands.length > 2 ? commands.join('') : '';
};
module.exports = format;
//# sourceMappingURL=index.js.map